/// @file dltLogger.h
///
/// @brief Implements the DLT specific logger
///
/// @component Uspi/DeviceDetector
///
/// @author F.Berat / ADITG/SWG / fberat@de.adit-jv.com
///
/// @copyright (c) 2016 Advanced Driver Information Technology.
/// This code is developed by Advanced Driver Information Technology.
/// Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
/// All rights reserved.
///
/// @see Log SyslogLogger

#include <iostream>
#include <string>

#include <dlt/dlt.h>

#ifndef __DLT_LOGGER_H__
#define __DLT_LOGGER_H__

#include "logger.h"

namespace adit {
namespace uspi {

/// @brief The DLT log class
///
/// This class allows to use DLT as a standard ostream output.
class DltLog : public Log {
public:
    /// Creates a DltLog object that will register ident as DLT context
    explicit DltLog(const char *ident = LOGGER_IDENTITY);
    ~DltLog();

protected:
    /// Flushes the @ref mBuffer to DLT if non-empty
    int sync();
    /// Add a character to the buffer and sync if EOF is met.
    int overflow(int c);

private:
    /// Converts a @ref LogPriority& to a @c DltLogLevelType
    DltLogLevelType toLogPriority(const LogPriority& log_priority);

    /// The DLT specific context member
    DLT_DECLARE_CONTEXT(dd_dlt);
};

} // namespace uspi
} // namespace adit

#endif // __DLT_LOGGER_H__
